/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class MaxMinParameter
extends Analog {
    private static final long serialVersionUID = 3492969802204634051L;
    private int blockSerializedDataVersion = 1;
    private static final transient int MIN_VALUE = Short.MIN_VALUE;
    private static final transient int MAX_VALUE = Short.MAX_VALUE;
    private static final transient int MODE_MAX_VALUE = 3;
    private static final transient int MODE_MIN_VALUE = 0;
    private transient double fMaxValue;
    private transient double fMinValue;
    private transient double fOutputValue;
    private transient boolean fState = false;
    private boolean fResetMaxMin;
    private IntegerOrBlockReference fMode;

    public MaxMinParameter() {
    }

    public MaxMinParameter(Block block) {
        super(block);
        this.setRemanenceAvailable(true);
    }

    public IntegerOrBlockReference getModeProperties() {
        if (this.fMode == null) {
            this.fMode = new IntegerOrBlockReference(this);
            AnalogValueProperties analogValueProperties = new AnalogValueProperties(0, 3, 1, 0, 0, "error.dialog.invalidValue", "Invalid Value");
            analogValueProperties.setSuppressLeadingZeroes(true);
            this.fMode.setIntValueProperties(analogValueProperties);
        }
        return this.fMode;
    }

    public void setModeProperties(IntegerOrBlockReference value) {
        this.fMode.setValue(value);
    }

    public AnalogValueProperties getMinimumValue() {
        return new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, (int)this.fMinValue, 0, this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
    }

    public AnalogValueProperties getMaximumValue() {
        return new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, (int)this.fMaxValue, 0, this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
    }

    public double getOutputValue() {
        return this.fOutputValue;
    }

    public AnalogValueProperties getAmplifiedXProperties() {
        if (this.fAmplifiedXProperties == null) {
            this.fAmplifiedXProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, (int)this.fXInput, 0, this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedXProperties.setCurrentValue(this.getMeasurement().getAmplifiedValue((int)this.fXInput));
        return this.fAmplifiedXProperties;
    }

    public double calculateAnalogValue(double ax, boolean en, boolean s1) {
        int modeValue = this.getModeProperties().getValue(Short.MIN_VALUE, Short.MAX_VALUE);
        this.fXInput = ax;
        if (!this.fState) {
            if (en) {
                this.fMinValue = ax;
                this.fMaxValue = ax;
                this.fOutputValue = ax;
                this.fState = true;
            }
        } else if (en) {
            if (ax < this.fMinValue) {
                this.fMinValue = ax;
            }
            if (ax > this.fMaxValue) {
                this.fMaxValue = ax;
            }
            switch (modeValue) {
                case 0: {
                    this.fOutputValue = this.fMinValue;
                    break;
                }
                case 1: {
                    this.fOutputValue = this.fMaxValue;
                    break;
                }
                case 2: {
                    this.fOutputValue = s1 ? this.fMaxValue : this.fMinValue;
                    break;
                }
                default: {
                    this.fOutputValue = ax;
                    break;
                }
            }
        } else {
            if (this.fResetMaxMin) {
                this.fMinValue = 0.0;
                this.fMaxValue = 0.0;
                this.fOutputValue = 0.0;
            }
            this.fState = false;
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        return this.fOutputValue;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("Mode = ").append(this.getModeProperties().getParameterText()).append("\n");
        buffer.append("ResetMaxMin = ").append(this.isResetMaxMin());
        return buffer.toString();
    }

    public String calculateCurrentParameterText() {
        String minvalue = Util.addTrailingSpaces(Double.toString(this.fMinValue), 8);
        String maxvalue = Util.addTrailingSpaces(Double.toString(this.fMaxValue), 8);
        String value = minvalue + "\n" + maxvalue;
        this.fireParameterUpdateEvent();
        return value;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fMinValue = 0.0;
            this.fMaxValue = 0.0;
            this.fOutputValue = 0.0;
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fMode);
        dw.writeBoolean(this.fResetMaxMin);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fMode = (IntegerOrBlockReference)dr.readStorable();
        this.fResetMaxMin = dr.readBoolean();
    }

    public void setResetMaxMin(Boolean b) {
        this.fResetMaxMin = b;
    }

    public Boolean isResetMaxMin() {
        return this.fResetMaxMin;
    }
}

